# SEO 搜索引擎优化实战

> 让更多人发现你的产品



大家好，我是程序员鱼皮。我们团队做的程序员面试刷题网站 [面试鸭](https://www.mianshiya.com/) 上线不到半个月的时候，就被百度等各大搜索引擎收录和推荐了！

效果显而易见，用户搜索 “面试鸭” 的时候，第一个看到的就是我们自己的网站，从而给网站增加流量：

![](https://pic.yupi.icu/1/image-20240815102430905.png)

关于如何让搜索引擎更快地收录网站，其实是一门很深的学问，还有一个专业术语叫 SEO。对于个人站长来说，搜索引擎的流量是至关重要的，大家应该都希望自己的网站能够被更多人看到吧？暂且不说收益，有个访问量大的网站，写简历和面试的时候也能吹一波牛皮~ 所以我建议程序员朋友们最好对 SEO 有一定了解。

今天这篇文章，我就以自己的面试鸭网站为例，给大家分享一些 SEO 实用技巧，让大家的网站都能更快地被搜索引擎收录。同时，我还会介绍 AI 时代的新概念 —— GEO（生成式引擎优化），帮助你的产品在 AI 搜索时代也能被更多人发现。

无论你是用 Vibe Coding 做个人项目，还是想做一款真正的产品，掌握 SEO 和 GEO 的方法都能帮你获得更多流量。

⭐️ 也可以观看视频讲解，热乎的：https://www.bilibili.com/video/BV1tz421i7Q1


## 鱼皮 SEO 干货分享

### 一、什么是 SEO？

SEO 全称为 Search Engine Optimization，即搜索引擎优化，使网站更容易被搜索引擎收录和呈现，可以让更多人通过百度、谷歌之类的搜索引擎发现你的网站，从而提升网站的访问量和知名度。

在学习如何进行 SEO 优化前，我们先简单了解 SEO 的流程，也就是：搜索引擎是如何发现你的网站并且让用户搜索到的？



### 二、SEO 的流程

整个 SEO 过程可以分为四个主要阶段：抓取、收录、索引和排名。下面我就来详细讲解一下这四个步骤。

#### 1、抓取

抓取是 SEO 流程的第一步，搜索引擎会派出一群爬虫程序（俗称蜘蛛），它们会在互联网上到处爬行，访问各个网站，并抓取网页的内容。这些蜘蛛会按照链接从一个页面跳转到另一个页面，尽可能地遍历整个网站。

#### 2、收录

抓取完成后，搜索引擎会对网页内容进行分析，并决定是否将该页面收录到它的数据库中。被收录的页面才能在用户搜索时显示出来，因此，确保页面被收录是 SEO 中的关键一步。有的网站虽然有很多链接和内容，但是只要搜索引擎的蜘蛛不喜欢、不收录，那么别人即使专门对着你的网站搜，都搜不出来。

#### 3、索引

索引是指搜索引擎将已收录的网页内容进行整理和分类，并建立一个巨大的索引库。这个过程类似于给每个网页打上标签，以便在用户搜索时，搜索引擎能够迅速找到与搜索词相关的网页。

比如我们的面试鸭网站内容中包括：Java面试题库、前端面试题库、C++面试题库，那么这几个词就有可能被设置为索引。用户搜索内容时如果包含了这些词，就有可能搜索我们的网站。

#### 4、排名

现在网站那么多，同样的索引也非常多，如何保证用户优先搜到我们的网站呢？这就涉及到 SEO 的最后一步 —— 排名。

当用户在搜索引擎中输入关键词时，搜索引擎会根据其算法，从索引库中挑选出最相关的网页，并 **按照相关性、权重、网站质量** 等因素进行排序，决定哪些网页出现在搜索结果的前几页。

这就是 SEO 的流程，我下面要分享的 SEO 优化技巧，也都是围绕这些流程展开。



### 三、如何进行 SEO 优化？

#### 1、关键词优化
关键词是指用户在搜索引擎中输入的词汇，可以通过在网站的 HTML 头信息中设置关键词（Keywords）和描述（Description）等信息，来增加网站的索引、并提高网页在相关搜索中的排名。

关键词的选择需要精确并且跟网站内容强相关，避免过度堆砌关键词，以免被搜索引擎判定为作弊行为。

比如要做一个面试刷题网站，可以设置下列关键词和描述：

```html
<meta name="keywords" content="程序员面试,Java面试题,程序员求职,计算机">
<meta name="description" content="程序员面试刷题，就来面试鸭，程序员免费求职面试刷题网站。海量高频Java面试题,帮你备战技术面试。">
```



#### 2、网站结构优化
网站结构优化分为 2 点：整站页面结构优化和每个页面的内容结构优化。

对于整个网站，页面嵌套的层次应当尽量扁平化、尽量缩短页面层级，以减少爬虫抓取的难度。

举个例子，下面两种网站结构，你觉得哪种结构的页面更容易被爬虫全部访问到呢？

![](https://pic.yupi.icu/1/image-20240815112845394.png)

答案不言而喻，对于你想更快被搜索引擎发现的重要页面，应该尽可能缩短跳转到该网站的路径，并且适当多增加一些跳转到该页面的入口。

对于每个页面，应当有明确的层次结构，可以使用合理的标题标签（如一级标题  `<h1>` ）使页面内容更加易于索引。



#### 3、友情链接

我大学刚开始做个人网站的时候，就是通过友情链接的方式来增加网站的权重（虽然效果有限）。操作方法很简单，你的网站上添加别人网站的链接，别人的网站添加你的网站的链接，你们双方的网站互相推荐，就更容易提升在搜索引擎中的排名。

友链背后的原理也很简单。很多搜索引擎都会按照权重对网站进行排名，权重是怎么计算的呢？一种很简单的算法（Page Rank），就是每个网站都有自己的票数，每有一个别人的网站添加了跳转到你的网站的友情链接，就相当于给你的网站投一票，得票数高的网站就能获得更高的权重和排名。友链就相当于互相投票，比 1 票都没有的网站要好。

![](https://pic.yupi.icu/1/image-20240815113641780.png)

当然，这种互相推荐的方式需要谨慎使用，避免过度交换链接，可能会导致权重分散。



#### 4、Sitemap 文件
Sitemap 网站地图是一个列出了你网站所有页面的文件，通常放在网站的根目录下，或者通过 robots.txt 文件指定其位置。它可以帮助搜索引擎更快速地了解你网站的结构，并抓取你希望优先收录的页面。

就相当于你给爬虫发了一份地图，爬虫就不容易迷路，也不容易错过你网站的重要页面。

对于结构比较简单的网站，使用静态的、固定不变的 Sitemap 就足够了。如下图：

![](https://pic.yupi.icu/1/image-20240815114215436.png)

但对于内容持续更新的网站，还有更高级的操作，就是利用程序自动生成动态的 Sitemap，比如把每天新增的题目生成为一个 Sitemap 文件，便于让爬虫更快发现最新的内容。

此外，有些搜索引擎还支持主动上传提交 Sitemap 文件，可以进一步缩短网站被发现和收录的时间。



#### 5、SSR 服务端渲染

注意，这里的 SSR 不是我们玩游戏抽卡说的那个！

SSR 服务端渲染是 SEO 最为有效的技术之一。是指在服务器端生成 **完整的 HTML 页面** ，并将其直接发送到浏览器。相比传统的前端 AJAX 动态请求数据的渲染方式，SSR 能够让搜索引擎更容易抓取到完整页面内容，从而提升 SEO 效果。

举个例子，如果是动态请求数据的前端网站，爬虫看到的网页内容可能是残缺不全的，如下图：

![](https://pic.yupi.icu/1/image-20240815114606517.png)

因为浏览器是从服务器拉取到网页后，再加载 JS 脚本，最后才发送请求来获取数据。

而如果使用了服务端渲染，服务器会完成对数据的请求，并且将数据拼装到页面里，再返回给前端，爬虫看到的网页内容更完整，如下图：

![](https://pic.yupi.icu/1/image-20240815114910820.png)

服务端渲染的效果虽然好，但也会加重服务器的压力，而且开发成本通常会更高。比如我们的面试鸭使用 Next.js 框架开发，开发过程中也踩了不少坑。

哦对了，用 PHP 来开发服务端渲染的网站是很方便的，这可能也是为什么以前 PHP 那么流行的原因之一。



#### 6、SSG 静态站点生成

和 SSR 有点类似，SSG 是 SEO 优化的另一大杀器。是指在构建网站时，预先生成所有页面的 **静态 HTML 文件** ，并将其直接部署到服务器上。当用户访问网站时，直接获取到生成好的 HTML 文件即可，相比 SSR 服务端渲染，都不需要服务器再临时去请求数据了。

这种方法不仅大大提高了页面加载速度，而且使得搜索引擎能够更快、更完整地索引所有页面。所以很多博客站点生成器（比如 Hugo、VuePress、Hexo）都是将写好的文章打包生成为静态 HTML 后，再部署到服务器上。

当然，SSG 也不是银弹，适用于内容较为固定、更新频率较低的网站，如个人博客等。静态网站本质上就是一种缓存，如果网页内容频繁变化，就要频繁更新这个文件，也会有不小的成本。

所以我们可以想到一种更高级的策略：SSR + SSG 结合！内容相对固定的网页使用静态生成，内容变化的网页使用服务端渲染，不需要 SEO 的网页纯客户端渲染即可。



#### 7、砸米

注意，以上方式并不保证绝对有效，只是增加搜索引擎收录和排名优化的概率，SEO 策略是需要持续调整和长时间验证的。

如果团队内没有懂 SEO 的技术人员，又想快速让自己的网站被搜索引擎推荐，那就只能 “砸米” 了，简单粗暴，就是花钱买广告，让你的网页在搜索结果的前几名出现。很多公司也都是这么做的，但对于没有收益的个人站长来说，还是老老实实用前面推荐的方式吧。



## AI 时代的 GEO：生成式引擎优化

随着 ChatGPT 等 AI 对话工具的普及，越来越多的用户开始使用 AI 来搜索信息，而不是传统的搜索引擎。这就催生了一个新的概念 **GEO（Generative Engine Optimization，生成式引擎优化）**。



### 什么是 GEO？

GEO 是指优化你的内容，使其更容易被 AI 搜索引擎（如 ChatGPT、Perplexity、Gemini 等）理解和引用。当用户向 AI 提问时，AI 会从互联网上抓取相关内容，然后生成回答。如果你的网站内容被 AI 引用，就能获得更多曝光。



### GEO 和 SEO 的区别

- SEO：优化网站，让传统搜索引擎（如百度、谷歌）更容易收录和排名
- GEO：优化内容，让 AI 搜索引擎更容易理解和引用



### 如何做好 GEO？

1）内容结构化

AI 更喜欢结构清晰的内容。使用标题、列表、表格等方式组织内容，让 AI 更容易提取关键信息。

2）提供权威信息

AI 更倾向于引用权威、准确的信息。确保你的内容有数据支撑、有来源引用，提高内容的可信度。

3）使用自然语言

AI 理解自然语言的能力很强。用通俗易懂的语言写作，避免过度专业化的术语，让 AI 更容易理解你的内容。

4）回答用户问题

AI 搜索通常是以问答的形式进行的。在内容中直接回答用户可能提出的问题，比如 “如何做 XX”、“XX 是什么”，这样更容易被 AI 引用。

5）保持内容更新

AI 倾向于引用最新的内容。定期更新你的网站内容，保持信息的时效性。

6）提供完整的上下文

AI 需要理解内容的上下文才能准确引用。确保每篇文章都有完整的背景介绍和详细的说明，不要让读者（和 AI）感到困惑。



## 写在最后


在 Vibe Coding 时代，用 AI 做产品已经很容易了。但是，如何让更多人发现你的产品，仍然需要你掌握 SEO 和 GEO 的方法。

加油，让你的产品被更多人发现吧~




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
